/************************************************************************/
/*									*/
/*	LIBSGLE.C				(C) 1/94 Ch. Muenkel	*/
/*	Extensions to the (basic) SGL library				*/
/*									*/
/************************************************************************/
/*									*/
/*	Simple Graphics Library						*/
/*	An easy to use interface to the X11 window system		*/
/*									*/
/************************************************************************/
/*									*/
/*	Author:	Christian Muenkel					*/
/*		Present address:					*/
/*		muenkel@carbo.tphys.uni-heidelberg.de			*/
/*		Christian Muenkel					*/
/*		Institut fuer Theoretische Physik			*/
/*		Philosophenweg 19					*/
/*		69120 Heidelberg - Germany				*/
/*									*/
/************************************************************************/
/* version      date            comment                                 */
/*                                                                      */
/* V1.0		 1/94		first implementation 			*/
/* V1.1		 4/94		z-buffer / Gouraud-shading		*/
/*				shading: draw in Image (not pixmap)	*/
/*				ppm-file display support		*/
/*                                                                      */
/************************************************************************/
/*                                                                      */
/* To do:								*/
/*                                                                      */
/************************************************************************/

#include	<stdio.h>
#include	<stdlib.h>
#include	<math.h>

#undef		__SGL_MAIN
#include	"sglglob.h"



/************************************************************************/
/************************************************************************/
/*									*/
/* INITIALIZATIONS ...							*/
/*									*/
/************************************************************************/
/************************************************************************/




/************************************************************************/
/************************************************************************/
/*									*/
/*  int		sgl_create_win(void)					*/
/*		create new X11 window					*/
/*		returns selection number of window 			*/
/*									*/
/************************************************************************/
/************************************************************************/
int	sgl_create_win(int new_x, int new_y)
{
 return(sgl_priv_create_win(new_x, new_y, 0));
}

/************************************************************************/
/************************************************************************/
/*									*/
/*  int		sgl_set_win(Window, int, int)				*/
/*		create new X11 window					*/
/*		returns selection number of window 			*/
/*									*/
/************************************************************************/
/************************************************************************/
int	sgl_set_win(Window parent, int new_x, int new_y)
{
  return(sgl_priv_create_win(new_x, new_y, parent));
}


/*
 * 
 * make window one pixel smaller in each direction
 * temporary hack to create parent expose events
 * AL 96
 *
 */
int	sgl_priv_create_win(int new_x, int new_y, Window parent)
{
  int		i;
  char		str[256];
  int	mask;
  XSetWindowAttributes attr;
  unsigned long gc_valmask;
  XGCValues	gc_val;

  if (flag_initialized != True)
   { fprintf(stderr,"SGL_CREATE_WIN: You must! call sgl_init first.\n");
     return(-1);
   }
  else if (GD_num >= MAX_X11GD_STRUCT)
   { fprintf(stderr,"SGL_CREATE_WIN: Maximum of %d windows exceeded.\n",
		MAX_X11GD_STRUCT);
     return(-1);
   }

  /***** allocate memory ************************************************/
  GD_act = GD_num;			/* select next free window	*/
  GD_num++;
  X11GD = (struct X11GlobalData *) malloc(sizeof(struct X11GlobalData));
  if (X11GD == NULL)
     FatalError("SGL_INIT: Can't allocate X11 global data structure.\n");
  X11GD->win_sx = new_x-4;
  X11GD->win_sy = new_y-4;
  X11GD->win_px = 2;
  X11GD->win_py = 2;
  X11GD->win_x_min = 0.0;
  X11GD->win_y_min = 0.0;
  X11GD->win_x_max = 1.0;
  X11GD->win_y_max = 1.0;
  X11GD->win_idx = 1.0;
  X11GD->win_idy = 1.0;

  X11GD_all[GD_act] = X11GD;

  /***** Open X window display ******************************************/
  /***** done already in create_colmap **********************************/
  X11GD->disp_name = X11CD->disp_name;
  X11GD->disp  = X11CD->disp;
  X11GD->scrnn = X11CD->scrnn;
  X11GD->scrn  = X11CD->scrn;
  X11GD->vistype = X11CD->vistype;
  X11GD->vis = X11CD->vis;
  X11GD->depth = X11CD->depth;

  sgl3d_create_win();		/* additional 3d parameters	*/
  

  mask = 0;
  attr.colormap = X11CD->colmap;
  mask |= CWColormap;
  attr.border_pixel = BlackPixel(X11GD->disp,X11GD->scrnn);
  mask |= CWBorderPixel;

  attr.backing_store = Always; /* Always doesn't work on SG Indy ??? */
  mask |= CWBackingStore;
  if (parent == 0)
   { X11GD->win = XCreateWindow(X11GD->disp,
	RootWindow(X11GD->disp,X11GD->scrnn),
	0,0, X11GD->win_sx,X11GD->win_sy, 1, X11GD->depth, InputOutput,
	X11GD->vis, mask, &attr);
   }
  else if (parent == -1)
   { X11GD->win = XCreateWindow(X11GD->disp,
	RootWindow(X11GD->disp,X11GD->scrnn),
	0,0, X11GD->win_sx,X11GD->win_sy, 1, X11GD->depth, InputOutput,
	X11GD->vis, mask, &attr);
   }
  else
   { 
	 X11GD->win = XCreateWindow(X11GD->disp,parent,
	0,0, X11GD->win_sx,X11GD->win_sy, 0, X11GD->depth, InputOutput,
	X11GD->vis, mask, &attr);
   }

  switch(X11GD->vistype)
   { case VISTYPE_TrueColor:
  	XStoreName(X11GD->disp, X11GD->win, "SGL TrueColor");
	break;
     case VISTYPE_PseudoColor:
  	XStoreName(X11GD->disp, X11GD->win, "SGL PseudoColor");
	break;
     case VISTYPE_StaticGray:
  	XStoreName(X11GD->disp, X11GD->win, "SGL StaticGray");
	break;
     case VISTYPE_GrayScale:
  	XStoreName(X11GD->disp, X11GD->win, "SGL GrayScale");
	break;
   }


  gc_valmask = 0;
  gc_val.line_width = 0;
  gc_valmask |= GCLineWidth;
	gc_val.graphics_exposures=True;
	gc_valmask |= GCGraphicsExposures;
  X11GD->gc = XCreateGC( X11GD->disp, X11GD->win,gc_valmask, &gc_val);

  X11GD->pm = XCreatePixmap( X11GD->disp, X11GD->win,
		X11GD->win_sx,X11GD->win_sy,X11GD->depth);
  if (!X11GD->pm) 
     FatalError("SGL_INIT: Couldn't create X pixmap.");

  X11GD->xim =XCreateImage(X11GD->disp, X11GD->vis,
	X11GD->depth,ZPixmap, 0, NULL,X11GD->win_sx, X11GD->win_sy, 32, 0);
  if (!X11GD->xim) 
	FatalError("sgl_init: Couldn't create X image!");
  X11GD->imdata = (char *) malloc(X11GD->win_sy * X11GD->xim->bytes_per_line);
  if (!X11GD->imdata) 
	FatalError("sgl_init: Couldn't malloc X image!");
  for (i = 0; i < X11GD->win_sy*X11GD->xim->bytes_per_line; i++)
    X11GD->imdata[i] = 0;
  X11GD->xim->data = (char *) X11GD->imdata;

  XMapRaised(X11GD->disp, X11GD->win);
  XMoveWindow(X11GD->disp, X11GD->win,X11GD->win_px,X11GD->win_py);
  XSetWindowColormap( X11GD->disp, X11GD->win,X11CD->colmap);

  if (debugging == True) 
   { switch(X11GD->vistype)
      { case VISTYPE_GrayScale:
	fprintf(stderr,"SGL: display type is GrayScale.\n");
	break;
	case VISTYPE_StaticGray:
	fprintf(stderr,"SGL: display type is StaticGray.\n");
	break;
	case VISTYPE_PseudoColor:
	fprintf(stderr,"SGL: display type is PseudoColor.\n");
	break;
	case VISTYPE_TrueColor:
	fprintf(stderr,"SGL: display type is TrueColor.\n");
	break;
	default:
	fprintf(stderr,"SGL: display type is unknown.\n");
	break;
      }
   }

  XSync(X11GD->disp, X11GD->win);

  XSetBackground( X11GD->disp, X11GD->gc, X11CD->color_pixel[0]);
  XSetForeground( X11GD->disp, X11GD->gc, X11CD->color_pixel[0]);
  XFillRectangle( X11GD->disp, X11GD->pm, X11GD->gc, 0,0,
	X11GD->win_sx,X11GD->win_sy);
  XDrawLine(X11GD->disp,X11GD->pm,X11GD->gc,0,0,X11GD->win_sx,X11GD->win_sy);
  XCopyArea(X11GD->disp,X11GD->pm,X11GD->win,X11GD->gc,0,0,
		X11GD->win_sx,X11GD->win_sy,0,0);
  XSetForeground( X11GD->disp, X11GD->gc, X11CD->color_pixel[1]);
  XSync(X11GD->disp, X11GD->win);

  return(GD_act);
}


/************************************************************************/
/************************************************************************/
/*									*/
/*  void	sgl_delete_win()					*/
/*		delete a created X11 window for drawing			*/
/*									*/
/************************************************************************/
/************************************************************************/
void	sgl_delete_win()
{
  sgl3d_free_win();
  XFreePixmap(X11GD_all[GD_act]->disp,X11GD_all[GD_act]->pm);
  free(X11GD_all[GD_act]->imdata);
  free(X11GD3D_all[GD_act]);
  
}


/************************************************************************/
/************************************************************************/
/*									*/
/*  void	sgl_select_win(int win)					*/
/*		select a created X11 window for drawing			*/
/*									*/
/************************************************************************/
/************************************************************************/
void	sgl_select_win(int win)
{
 if (win < 0 || win >= GD_num)
  { fprintf(stderr,"SGL_SELECT_WIN: Selected window (%d) out of range\n",win);
    return;
  }
 else
  { GD_act = win;
    X11GD   = X11GD_all[GD_act];
    X11GD3D = X11GD3D_all[GD_act];
    sgl3d_select_win();
  }  
}

/************************************************************************/
/************************************************************************/
/*									*/
/*  void	sgl_map_win(int win)					*/
/*		map a created window onto screen			*/
/*									*/
/************************************************************************/
/************************************************************************/
void	sgl_map_win(int win)
{
 if (win < 0 || win >= GD_num)
  { fprintf(stderr,"SGL_MAP_WIN: Selected window (%d) out of range\n",win);
    return;
  }
 else
  { XMapWindow(X11GD_all[win]->disp, X11GD_all[win]->win);
  }  
}

/************************************************************************/
/************************************************************************/
/*									*/
/*  void	sgl_unmap_win(int win)					*/
/*		unmap a created window 					*/
/*									*/
/************************************************************************/
/************************************************************************/
void	sgl_unmap_win(int win)
{
 if (win < 0 || win >= GD_num)
  { fprintf(stderr,"SGL_UNMAP_WIN: Selected window (%d) out of range\n",win);
    return;
  }
 else
  { XUnmapWindow(X11GD_all[win]->disp, X11GD_all[win]->win);
  }  
}

/************************************************************************/
/************************************************************************/
/*									*/
/*  void	sgl_pos_win(int x, int y)				*/
/*		position a created window on screen			*/
/*									*/
/************************************************************************/
/************************************************************************/
void	sgl_pos_win(int x, int y)
{
  XMoveWindow(X11GD->disp, X11GD->win,x,y);
  X11GD->win_px = x;
  X11GD->win_py = y;
}

/************************************************************************/
/************************************************************************/
/*									*/
/* DRAWING FUNCTIONS							*/
/*									*/
/************************************************************************/
/************************************************************************/


/************************************************************************/
/************************************************************************/
/*									*/
/* Modifiers 								*/
/*									*/
/************************************************************************/
/************************************************************************/

/************************************************************************/
/************************************************************************/
/*                                                                      */
/*  void        sgl_linewidth(int width)                                */
/*		set linewidth in pixels					*/
/*                                                                      */
/************************************************************************/
/************************************************************************/
void	sgl_linewidth(int width)
{
if(X11GD->depth<24)
 XSetLineAttributes(X11GD->disp, X11GD->gc, (unsigned int) width,
	LineSolid,CapNotLast,JoinMiter);
}




/************************************************************************/
/************************************************************************/
/*									*/
/* COLOR FUNCTIONS							*/
/*									*/
/************************************************************************/
/************************************************************************/



/************************************************************************/
/************************************************************************/
/*									*/
/* MISC. ...								*/
/*									*/
/************************************************************************/
/************************************************************************/

void	sgl_put_ppm(char *pic, int px, int py)
{
  int		i,j;
  unsigned char	*ptr;
  unsigned long	color;

  ptr = (unsigned char *) pic;
  for (j = 0; j < py; j++)
   { for (i = 0; i < px; i++)
      { color = *ptr | (*(ptr+1))<<8 | (*(ptr+2))<<16;
        ptr += 3;
        XPutPixel(X11GD->xim,i,j,color);
      }
   }

  XPutImage(X11GD->disp,X11GD->win,X11GD->gc,
	X11GD->xim,
	0,0,0,0,(unsigned int)px,(unsigned int)py);
  XSync(X11GD->disp, X11GD->win);
}


Window          sgl_get_windowid(int win)
{
  return(X11GD_all[win]->win);
}
