/************************************************************************/
/*									*/
/*	SGL3D.H					(C) 1/94 Ch. Muenkel	*/
/*	Include file for libsgl3d.a library				*/
/*									*/
/************************************************************************/
/*									*/
/*	Simple Graphics Library	- 3D					*/
/*	An easy to use interface to the X11 window system		*/
/*	This is the wireframe 3D extension to the SGL library		*/
/*									*/
/************************************************************************/
/*									*/
/*	Author:	Christian Muenkel					*/
/*		Present address:					*/
/*		muenkel@carbo.tphys.uni-heidelberg.de			*/
/*		Christian Muenkel					*/
/*		Institut fuer Theoretische Physik			*/
/*		Philosophenweg 19					*/
/*		69120 Heidelberg - Germany				*/
/*									*/
/************************************************************************/
/* version      date            comment                                 */
/*                                                                      */
/* V1.0		 1/94		first implementation 			*/
/* v1.1		 4/94		z-buffer support			*/
/*				shading: draw in Image (not pixmap)	*/
/*                                                                      */
/************************************************************************/

#ifndef		__SG3D_INCLUDED
#define		__SG3D_INCLUDED


/************************************************************************/
/* global defines, which should be accesible from all modules		*/
/************************************************************************/
#define	SGL3D_PROJ_ORTHO	1
#define	SGL3D_PROJ_PERSP	2

typedef float           SGLMatrix[4][4];
typedef float           SGLVector[4];
typedef int             SGLVectori[3];
typedef float           SGLVrgb[3];  


/************************************************************************/
/* function declaration							*/
/************************************************************************/
void		sgl3d_init(void);
void		sgl3d_create_win(void);
void		sgl3d_free_win(void);
void		sgl3d_set_win(void);
void		sgl3d_select_win(void);

void		sgl3d_line(float,float,float,float,float,float);
void		sgl3d_circle(float,float,float,float);
void		sgl3d_polygon(int,float *,float *,float *);
void		sgl3d_proj_points(int,float *,float *,float *,float *, float *, float *, int *);
void		sgl3d_spherel(float,float,float,float);

void		sgl3d_trans(float,float,float);
void		sgl3d_scale(float,float,float);
void		sgl3d_rotx(float);
void		sgl3d_roty(float);
void		sgl3d_rotz(float);
void		sgl3d_rot(float,float,float,float);
void		sgl3d_identity(void);

void		sgl3d_matrix_push(void);
void		sgl3d_matrix_pop(void);

void		sgl3d_vec_trans(SGLVector);
void		sgl3d_vec_transpre(SGLVector);
void		sgl3d_matrix_mult(SGLMatrix,SGLMatrix,SGLMatrix);
void		sgl3d_matrix_cpy(SGLMatrix,SGLMatrix);
void		sgl3d_matrix_store(int);
void		sgl3d_matrix_restore(int);

void		sgl3d_matrix_proj_init(void);

void		sgl3d_set_cop(float,float,float);
void		sgl3d_set_ref(float,float,float);
void		sgl3d_set_vpar(float,float,float);
void		sgl3d_set_vdefault(void);

void		sgl3d_set_shading(char *);

void		sgl3d_get_cop(float *,float *,float *);
void		sgl3d_get_ref(float *,float *,float *);
void		sgl3d_get_vpar(float *,float *,float *);

void		sgl3d_spherel_init(void);


#define POLY_NMAX 8             /* max #sides to a polygon; change if needed */

typedef struct {                /* A POLYGON VERTEX */
    float sx, sy, sz, sw;      /* screen space position (sometimes homo.) */
    float x, y, z;             /* world space position */
    float u, v, q;             /* texture position (sometimes homogeneous) */
    float r, g, b;             /* (red,green,blue) color */
    float nx, ny, nz;          /* world space normal vector */
} Poly_vert;
/* update poly.c if you change this structure */

typedef struct {                /* A POLYGON */
    int n;                      /* number of sides */
    int mask;                   /* interpolation mask for vertex elems */
    Poly_vert vert[POLY_NMAX];  /* vertices */
} Poly;

extern Poly_vert *poly_dummy;   /* used superficially by POLY_MASK macro */
#define POLY_MASK(elem) (1 << (&poly_dummy->elem - (float *)poly_dummy))

void		sgl3d_polyshade(Poly *);
void		sgl3d_polygons(int,float *,float *,float *,float *,float *,float *);
void		sgl3d_spheres(float,float,float,float);
void		sgl3d_spheres_init(void);
void		sgl3d_cylinders(float,float,float,float,float,float,float);
void		sgl3d_spheresf(float,float,float,float);
void		sgl3d_spheresf_init(void);

void		sgl3d_zclear(void);


#endif
